<?php
// roleta.php
// Web App Flutuante com suas regras do PDF
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>🎯 Dica Roleta - Estratégia PDF</title>
  <style>
    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: rgba(0, 0, 0, 0.9);
      color: white;
      padding: 10px;
      margin: 0;
      border-bottom: 2px solid #ff3333;
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      z-index: 999999;
      box-shadow: 0 4px 10px rgba(0,0,0,0.5);
      backdrop-filter: blur(5px);
      -webkit-backdrop-filter: blur(5px);
    }

    .container {
      display: flex;
      align-items: center;
      gap: 15px;
      max-width: 100%;
      overflow-x: auto;
      padding: 5px 10px;
    }

    .input-box {
      display: flex;
      align-items: center;
      gap: 5px;
      background: #111;
      padding: 8px 12px;
      border-radius: 6px;
      border: 1px solid #333;
    }

    input {
      width: 60px;
      padding: 6px;
      text-align: center;
      background: #222;
      border: 1px solid #555;
      color: white;
      border-radius: 4px;
      font-size: 14px;
    }

    button {
      padding: 6px 12px;
      background: #e74c3c;
      color: white;
      border: none;
      border-radius: 4px;
      cursor: pointer;
      font-size: 14px;
    }

    .dica {
      background: rgba(0, 0, 0, 0.7);
      padding: 8px 12px;
      border-radius: 4px;
      font-weight: bold;
      font-size: 14px;
      min-width: 200px;
      text-align: center;
      line-height: 1.4;
    }

    .numeros {
      display: flex;
      gap: 10px;
      font-size: 12px;
      opacity: 0.8;
    }

    .principal {
      color: #ffcc00;
      font-weight: bold;
    }

    .vizinho {
      color: #00ccff;
      font-weight: bold;
    }

    .historico {
      background: #111;
      padding: 5px 10px;
      border-radius: 4px;
      font-size: 12px;
      opacity: 0.8;
      max-width: 200px;
      white-space: nowrap;
      overflow: hidden;
      text-overflow: ellipsis;
    }
  </style>
</head>
<body>
  <div class="container">
    <div class="input-box">
      <span>Último:</span>
      <input type="number" id="numero" min="0" max="36" placeholder="0-36" />
      <button id="adicionar">▶</button>
    </div>

    <div class="dica" id="dica">Aguardando número...</div>

    <div class="numeros" id="numeros"></div>

    <div class="historico" id="historico">Nenhum número</div>
  </div>

  <script>
    // 🔢 SUAS REGRAS DO PDF (adaptadas para código)
    const REGRAS = {
      0: {
        instrucao: "Pegar 24 vizinhos e 28 com 4 vizinhos e proteção no 25 com 2 vizinhos",
        principais: [24, 28],
        vizinhos: [25]
      },
      1: {
        instrucao: "Pegar terminais 1 e 4 com um vizinho pra cada lado",
        principais: [1, 4],
        vizinhos: []
      },
      2: {
        instrucao: "Pegar terminais 2 e 5 com 2 vizinhos e proteger o 22 e 25 com 3 vizinhos",
        principais: [2, 5],
        vizinhos: [22, 25]
      },
      3: {
        instrucao: "Pegar o cavalo 2 5 8 com 1 vizinho pra cada lado",
        principais: [2, 5, 8],
        vizinhos: []
      },
      4: {
        instrucao: "Pegar os terminais 1 e 4 com 1 vizinho pra cada lado",
        principais: [1, 4],
        vizinhos: []
      },
      5: {
        instrucao: "Pegar os terminais 2 e 5 com 2 vizinhos pra cada lado",
        principais: [2, 5],
        vizinhos: []
      },
      6: {
        instrucao: "Pegar terminais 0 e 6 com 2 vizinhos pra cada lado",
        principais: [0, 6],
        vizinhos: []
      },
      7: {
        instrucao: "Pegar os terminais 7 com 4 vizinhos pra cada lado",
        principais: [7],
        vizinhos: []
      },
      8: {
        instrucao: "Pegar o cavalo 2 5 8 com 1 vizinho pra cada lado",
        principais: [2, 5, 8],
        vizinhos: []
      },
      9: {
        instrucao: "Pegar os terminais 1 8 9 com 1 vizinho pra cada lado",
        principais: [1, 8, 9],
        vizinhos: []
      },
      10: {
        instrucao: "Pegar os terminais 10 com 2 vizinhos pra cada lado",
        principais: [10],
        vizinhos: []
      },
      11: {
        instrucao: "Pegar os terminais 11 com 3 vizinhos pra cada lado",
        principais: [11],
        vizinhos: []
      },
      12: {
        instrucao: "Pegar os terminais 12 com 4 vizinhos pra cada lado",
        principais: [12],
        vizinhos: []
      },
      13: {
        instrucao: "Pegar os terminais 13 com 1 vizinho pra cada lado",
        principais: [13],
        vizinhos: []
      },
      14: {
        instrucao: "Pegar os terminais 14 com 2 vizinhos pra cada lado",
        principais: [14],
        vizinhos: []
      },
      15: {
        instrucao: "Pegar os terminais 15 com 3 vizinhos pra cada lado",
        principais: [15],
        vizinhos: []
      },
      16: {
        instrucao: "Pegar os terminais 16 com 4 vizinhos pra cada lado",
        principais: [16],
        vizinhos: []
      },
      17: {
        instrucao: "Pegar os terminais 17 com 1 vizinho pra cada lado",
        principais: [17],
        vizinhos: []
      },
      18: {
        instrucao: "Pegar os terminais 18 com 2 vizinhos pra cada lado",
        principais: [18],
        vizinhos: []
      },
      19: {
        instrucao: "Pegar os terminais 19 com 3 vizinhos pra cada lado",
        principais: [19],
        vizinhos: []
      },
      20: {
        instrucao: "Pegar os terminais 20 com 4 vizinhos pra cada lado",
        principais: [20],
        vizinhos: []
      },
      21: {
        instrucao: "Pegar os terminais 21 com 1 vizinho pra cada lado",
        principais: [21],
        vizinhos: []
      },
      22: {
        instrucao: "Pegar os terminais 22 com 2 vizinhos pra cada lado",
        principais: [22],
        vizinhos: []
      },
      23: {
        instrucao: "Pegar os terminais 23 com 3 vizinhos pra cada lado",
        principais: [23],
        vizinhos: []
      },
      24: {
        instrucao: "Pegar os terminais 24 com 4 vizinhos pra cada lado",
        principais: [24],
        vizinhos: []
      },
      25: {
        instrucao: "Pegar os terminais 25 com 1 vizinho pra cada lado",
        principais: [25],
        vizinhos: []
      },
      26: {
        instrucao: "Pegar os terminais 26 com 2 vizinhos pra cada lado",
        principais: [26],
        vizinhos: []
      },
      27: {
        instrucao: "Pegar os terminais 27 com 3 vizinhos pra cada lado",
        principais: [27],
        vizinhos: []
      },
      28: {
        instrucao: "Pegar os terminais 28 com 4 vizinhos pra cada lado",
        principais: [28],
        vizinhos: []
      },
      29: {
        instrucao: "Pegar os terminais 29 com 1 vizinho pra cada lado",
        principais: [29],
        vizinhos: []
      },
      30: {
        instrucao: "Pegar os terminais 30 com 2 vizinhos pra cada lado",
        principais: [30],
        vizinhos: []
      },
      31: {
        instrucao: "Pegar os terminais 31 com 3 vizinhos pra cada lado",
        principais: [31],
        vizinhos: []
      },
      32: {
        instrucao: "Pegar os terminais 32 com 4 vizinhos pra cada lado",
        principais: [32],
        vizinhos: []
      },
      33: {
        instrucao: "Pegar os terminais 33 com 1 vizinho pra cada lado",
        principais: [33],
        vizinhos: []
      },
      34: {
        instrucao: "Pegar os terminais 34 com 2 vizinhos pra cada lado",
        principais: [34],
        vizinhos: []
      },
      35: {
        instrucao: "Pegar os terminais 35 com 3 vizinhos pra cada lado",
        principais: [35],
        vizinhos: []
      },
      36: {
        instrucao: "Pegar os terminais 36 com 4 vizinhos pra cada lado",
        principais: [36],
        vizinhos: []
      }
    };

    let historico = [];

    document.getElementById('adicionar').addEventListener('click', function() {
      const valor = parseInt(document.getElementById('numero').value);
      if (!isNaN(valor) && valor >= 0 && valor <= 36) {
        historico.unshift(valor);
        if (historico.length > 5) historico.pop();

        document.getElementById('historico').innerText = `Histórico: ${historico.join(', ')}`;

        const regra = REGRAS[valor] || { instrucao: "Número não encontrado", principais: [], vizinhos: [] };

        document.getElementById('dica').innerHTML = 
          `<span style="color:#ffcc00;">🟨 NÚMEROS PRINCIPAIS:</span><br>` +
          `<span style="color:#00ccff;">🔵 NÚMEROS VIZINHOS:</span><br>` +
          `<span style="color:#ff3333; font-weight:bold;">NÚMERO = ${valor}</span><br><br>` +
          `${regra.instrucao}`;

        const numerosEl = document.getElementById('numeros');
        numerosEl.innerHTML = '';

        if (regra.principais.length > 0) {
          const p = document.createElement('span');
          p.innerHTML = `🟨 ${regra.principais.join(', ')}`;
          p.className = 'principal';
          numerosEl.appendChild(p);
        }

        if (regra.vizinhos.length > 0) {
          const v = document.createElement('span');
          v.innerHTML = `🔵 ${regra.vizinhos.join(', ')}`;
          v.className = 'vizinho';
          numerosEl.appendChild(v);
        }

        document.getElementById('numero').value = '';
        document.getElementById('numero').focus();
      } else {
        alert('Digite um número entre 0 e 36!');
      }
    });

    document.getElementById('numero').addEventListener('keypress', function(e) {
      if (e.key === 'Enter') {
        document.getElementById('adicionar').click();
      }
    });
  </script>
</body>
</html>